/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.util;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.productivity.java.syslog4j.SyslogCharSetIF;
import org.productivity.java.syslog4j.SyslogConstants;
import org.productivity.java.syslog4j.SyslogRuntimeException;

public final class SyslogUtility
implements SyslogConstants {
    private static final long serialVersionUID = 915031554586613648L;

    private SyslogUtility() {
    }

    public static final InetAddress getInetAddress(String string) throws SyslogRuntimeException {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new SyslogRuntimeException(unknownHostException);
        }
        return inetAddress;
    }

    public static final String getFacilityString(int n) {
        switch (n) {
            case 0: {
                return "kern";
            }
            case 8: {
                return "user";
            }
            case 16: {
                return "mail";
            }
            case 24: {
                return "daemon";
            }
            case 32: {
                return "auth";
            }
            case 40: {
                return "syslog";
            }
            case 48: {
                return "lpr";
            }
            case 56: {
                return "news";
            }
            case 64: {
                return "uucp";
            }
            case 72: {
                return "cron";
            }
            case 80: {
                return "authpriv";
            }
            case 88: {
                return "ftp";
            }
            case 128: {
                return "local0";
            }
            case 136: {
                return "local1";
            }
            case 144: {
                return "local2";
            }
            case 152: {
                return "local3";
            }
            case 160: {
                return "local4";
            }
            case 168: {
                return "local5";
            }
            case 176: {
                return "local6";
            }
            case 184: {
                return "local7";
            }
        }
        return "UNKNOWN";
    }

    public static final int getFacility(String string) {
        String string2 = string;
        if (string == null) {
            return -1;
        }
        string2 = string.trim();
        if ("KERN".equalsIgnoreCase(string2)) {
            return 0;
        }
        if ("USER".equalsIgnoreCase(string)) {
            return 8;
        }
        if ("MAIL".equalsIgnoreCase(string)) {
            return 16;
        }
        if ("DAEMON".equalsIgnoreCase(string)) {
            return 24;
        }
        if ("AUTH".equalsIgnoreCase(string)) {
            return 32;
        }
        if ("SYSLOG".equalsIgnoreCase(string)) {
            return 40;
        }
        if ("LPR".equalsIgnoreCase(string)) {
            return 48;
        }
        if ("NEWS".equalsIgnoreCase(string)) {
            return 56;
        }
        if ("UUCP".equalsIgnoreCase(string)) {
            return 64;
        }
        if ("CRON".equalsIgnoreCase(string)) {
            return 72;
        }
        if ("AUTHPRIV".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("FTP".equalsIgnoreCase(string)) {
            return 88;
        }
        if ("LOCAL0".equalsIgnoreCase(string)) {
            return 128;
        }
        if ("LOCAL1".equalsIgnoreCase(string)) {
            return 136;
        }
        if ("LOCAL2".equalsIgnoreCase(string)) {
            return 144;
        }
        if ("LOCAL3".equalsIgnoreCase(string)) {
            return 152;
        }
        if ("LOCAL4".equalsIgnoreCase(string)) {
            return 160;
        }
        if ("LOCAL5".equalsIgnoreCase(string)) {
            return 168;
        }
        if ("LOCAL6".equalsIgnoreCase(string)) {
            return 176;
        }
        if ("LOCAL7".equalsIgnoreCase(string)) {
            return 184;
        }
        return -1;
    }

    public static final int getLevel(String string) {
        String string2 = string;
        if (string == null) {
            return -1;
        }
        string2 = string.trim();
        if ("DEBUG".equalsIgnoreCase(string2)) {
            return 7;
        }
        if ("INFO".equalsIgnoreCase(string2)) {
            return 6;
        }
        if ("NOTICE".equalsIgnoreCase(string2)) {
            return 5;
        }
        if ("WARN".equalsIgnoreCase(string2)) {
            return 4;
        }
        if ("ERROR".equalsIgnoreCase(string2)) {
            return 3;
        }
        if ("CRITICAL".equalsIgnoreCase(string2)) {
            return 2;
        }
        if ("ALERT".equalsIgnoreCase(string2)) {
            return 1;
        }
        if ("EMERGENCY".equalsIgnoreCase(string2)) {
            return 0;
        }
        return -1;
    }

    public static final boolean isClassExists(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static final String getLocalName() {
        String string = "unknown";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string;
    }

    public static final byte[] getBytes(SyslogCharSetIF syslogCharSetIF, String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(syslogCharSetIF.getCharSet());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        return byArray;
    }

    public static final String newString(SyslogCharSetIF syslogCharSetIF, byte[] byArray) {
        String string = null;
        try {
            string = new String(byArray, syslogCharSetIF.getCharSet());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray);
        }
        return string;
    }

    public static final String getLevelString(int n) {
        switch (n) {
            case 7: {
                return "DEBUG";
            }
            case 6: {
                return "INFO";
            }
            case 5: {
                return "NOTICE";
            }
            case 4: {
                return "WARN";
            }
            case 3: {
                return "ERROR";
            }
            case 2: {
                return "CRITICAL";
            }
            case 1: {
                return "ALERT";
            }
            case 0: {
                return "EMERGENCY";
            }
        }
        return "UNKNOWN";
    }
}

