/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.AbstractSyslog;
import org.productivity.java.syslog4j.impl.AbstractSyslogConfigIF;
import org.productivity.java.syslog4j.util.SyslogUtility;

public abstract class AbstractSyslogWriter
implements Runnable,
Serializable {
    private static final long serialVersionUID = 836468466009035847L;
    protected AbstractSyslog syslog = null;
    protected List queuedMessages = null;
    protected Thread thread = null;
    protected AbstractSyslogConfigIF syslogConfig = null;
    protected boolean shutdown = false;

    public void initialize(AbstractSyslog abstractSyslog) {
        this.syslog = abstractSyslog;
        try {
            this.syslogConfig = (AbstractSyslogConfigIF)this.syslog.getConfig();
        }
        catch (ClassCastException classCastException) {
            throw new SyslogRuntimeException("config must implement interface AbstractSyslogConfigIF");
        }
        if (this.syslogConfig.isThreaded()) {
            this.queuedMessages = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(byte[] byArray) {
        List list = this.queuedMessages;
        synchronized (list) {
            this.queuedMessages.add(byArray);
        }
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public boolean hasThread() {
        return this.thread != null && this.thread.isAlive();
    }

    public abstract void write(byte[] var1);

    public abstract void flush();

    public abstract void shutdown();

    protected abstract void runCompleted();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.shutdown || !this.queuedMessages.isEmpty()) {
            LinkedList linkedList = null;
            Object object = this.queuedMessages;
            synchronized (object) {
                linkedList = new LinkedList(this.queuedMessages);
                this.queuedMessages.clear();
            }
            if (linkedList != null) {
                while (!linkedList.isEmpty()) {
                    object = (byte[])linkedList.remove(0);
                    try {
                        this.write((byte[])object);
                        this.syslog.setBackLogStatus(false);
                    }
                    catch (SyslogRuntimeException syslogRuntimeException) {
                        this.syslog.backLog(6, SyslogUtility.newString(this.syslog.getConfig(), (byte[])object), syslogRuntimeException);
                    }
                }
            }
            try {
                Thread.sleep(this.syslogConfig.getThreadLoopInterval());
            }
            catch (InterruptedException interruptedException) {}
        }
        this.runCompleted();
    }
}

