package org.productivity.java.syslog4j.server.impl;

import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.server.SyslogServerConfigIF;
import org.productivity.java.syslog4j.server.SyslogServerIF;

/**
* AbstractSyslogServer provides a base abstract implementation of the SyslogServerIF.
* 
* <p>Syslog4j is licensed under the Lesser GNU Public License v2.1.  A copy
* of the LGPL license is available in the META-INF folder in all
* distributions of Syslog4j and in the base directory of the "doc" ZIP.</p>
* 
* @author &lt;syslog4j@productivity.org&gt;
* @version $Id: AbstractSyslogServer.java,v 1.6 2008/11/07 15:15:41 cvs Exp $
*/
public abstract class AbstractSyslogServer implements SyslogServerIF {
	protected String syslogProtocol = null;
	protected AbstractSyslogServerConfig syslogServerConfig = null;
	protected Thread thread = null;
	
	protected boolean shutdown = false;
	
	public void initialize(String protocol, SyslogServerConfigIF config) throws SyslogRuntimeException {
		this.syslogProtocol = protocol;
		
		try {
			this.syslogServerConfig = (AbstractSyslogServerConfig) config;
			
		} catch (ClassCastException cce) {
			throw new SyslogRuntimeException(cce);
		}
		
		initialize();
	}
	
	public String getProtocol() {
		return this.syslogProtocol;
	}

	public SyslogServerConfigIF getConfig() {
		return this.syslogServerConfig;
	}
	
	protected abstract void initialize() throws SyslogRuntimeException;
	
	public void shutdown() throws SyslogRuntimeException {
		this.shutdown = true;
	}

	public Thread getThread() {
		return this.thread;
	}

	public void setThread(Thread thread) {
		this.thread = thread;
	}
}
